package it.eng.eremita.jpa.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import io.leangen.graphql.annotations.GraphQLQuery;

@Entity
@Table(name="MAIN_PERMESSO")
public class Permesso {
	
	String id;
	String descrizione;
	
	@Id
	@Column(name="ID")
	@GraphQLQuery(name="id")
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	
	@Column(name="DESCRIZIONE")
	@GraphQLQuery(name="descrizione")
	public String getDescrizione() {
		return descrizione;
	}
	public void setDescrizione(String descrizione) {
		this.descrizione = descrizione;
	}
	
	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof Permesso)) return false;
		
		Permesso ms = (Permesso)o;
		if (ms.getId()==this.getId()) return true;
		if (ms.getId()==null) return false;
		return (ms.getId().equals(this.getId()));

	}

}
